<!-- template="mla-mime-types" -->
7z,application/x-7z-compressed,archive,archive,7Zip compressed archive
aac,audio/aac,audio,audio,Apple QuickTime compressed audio used in iPods
ac3,audio/ac3,audio,audio,AC3 Audio File Format (Dolby Laboratories)
ai,application/postscript,default,postscript,Adobe PostScript
aif,audio/x-aiff,audio,audio,Audio Interchange File Format/Macintosh sound
aifc,audio/x-aiff,audio,audio,Audio Interchange File Format/Macintosh sound
aiff,audio/x-aiff,audio,audio,Audio Interchange File Format/Macintosh uncompressed sound
asc,text/plain,text,text,text
asf,video/x-ms-asf,video,video,Microsoft Advanced Systems Format (ASF)
asx,video/x-ms-asf,video,video,Microsoft video playlist. XML with entries giving URL for each file to play in order.
au,audio/basic,audio,audio,AU audio files
avi,video/msvideo,video,video,Audio Video Interleave (AVI) - earlier Microsoft video format
bin,application/octet-stream,default,binary,Binary Data/executable program
bmp,image/bmp,default,image,Bitmap Image File
c,text/plain,code,source_c,C Source File
cat,application/vnd.ms-pkiseccat,default,default,Microsoft Trust UI Provider - Security Catalog
cc,text/plain,code,source_cpp,C++ Source File
cdf,application/cdf,default,default,Microsoft Channel Definition Format
cgm,image/cgm,default,image,Computer Graphics Metafile
class,application/java,code,source_java,Compiled Java Bytecode File
clp,application/x-msclip,default,knotes,Microsoft Clipboard Clip
crd,application/x-mscardfile,default,knotes,Microsoft Information Card
css,text/css,code,stylesheet,Cascading Style Sheets (CSS)
csv,text/csv,text,text,Microsoft's format for import/export to Excel Word and Access.
dat,application/octet-stream,default,binary,Various Data formats
divx,video/divx,video,video,DivX LLC Video Format
dll,application/x-msdownload,code,exe_wine,Microsoft Windows Dynamic Link Library
doc,application/msword,document,document,Microsoft Word document formatted
docm,application/vnd.ms-word.document.macroEnabled.12,document,document,Micosoft Word - Macro-Enabled Document
docx,application/vnd.openxmlformats-officedocument.wordprocessingml.document,document,document,Microsoft Office - OOXML - Word Document
dot,application/msword,default,document,Microsoft Word Document Template
dotm,application/vnd.ms-word.template.macroEnabled.12,document,document,Micosoft Word - Macro-Enabled Template
dotx,application/vnd.openxmlformats-officedocument.wordprocessingml.template,document,document,Microsoft Office - OOXML - Word Document Template
dtd,application/xml-dtd,code,code,Document Type Definition
eps,application/postscript,default,postscript,Encapsulated Adobe PostScript
exe,application/x-msdownload,code,exe_wine,Windows executable program. Refered to as an application type in the associations editor.
flv,video/x-flv,video,video,Flash Video
gif,image/gif,default,image,Graphics Interchange Format
gtar,application/x-gtar,archive,archive,GNU Tar Files
gz,application/gzip,archive,archive,tar gzip
gzip,application/gzip,archive,archive,tar gzip
h,text/plain,code,source_h,C Header File
htm,text/html,code,code,HTML web browser
html,text/html,code,code,HyperText Markup Language (HTML)
ico,image/x-icon,default,image,Icon Image
ics,text/calendar,default,calendar,iCalendar
ief,image/ief,default,image,Image Exchange Format
ifb,text/calendar,default,calendar,Apple iCalendar
jpe,image/jpeg,default,image,JPEG/JIFF Image
jpeg,image/jpeg,default,image,JPEG/JIFF Image
jpg,image/jpeg,default,image,JPEG picture file
js,application/javascript,code,source_java,JavaScript; application/javascript is official; but text/javascript is more widely supported.
m13,application/x-msmediaview,default,default,Microsoft MediaView
m14,application/x-msmediaview,default,default,Microsoft MediaView
m4a,audio/mpeg,audio,audio,MPEG-4 Audio Layer
m4b,audio/mpeg,audio,audio,MPEG-4 Audio Layer Bookmarkable File
m4v,video/mp4,video,video,MPEG video files
mdb,application/x-msaccess,default,database,Microsoft Access Database
mid,audio/midi,audio,audio,MIDI - Musical Instrument Digital Interface
midi,audio/midi,audio,audio,MIDI - Musical Instrument Digital Interface
mka,audio/x-matroska,audio,audio,"Matroska Media Container, audio"
mkv,video/x-matroska,video,video,"Matroska Media Container, video"
mml,text/mathml,default,kformula,Mathmatics Markup Language
mny,application/x-msmoney,default,default,Microsoft Money
mov,video/quicktime,video,video,Quicktime movie player
movie,video/x-sgi-movie,video,video,SGI Movie
mp2,audio/x-mpeg,audio,audio,MPEG audio files
mp3,audio/x-mpeg,audio,audio,mp3/mpeg compressed audio. Popular format for portable music players.
mp4,video/mp4,video,video,MPEG4
mpa,audio/MPA,default,audio,MPEG audio files
mpe,video/mpeg,video,video,mpeg movie player
mpeg,video/mpeg,video,video,MPEG Video
mpg,video/mpeg,video,video,mpeg movie player
mpp,application/vnd.ms-project,default,default,Microsoft Project
msg,application/vnd.ms-outlook,default,message,Microsoft Outlook Message
mvb,application/x-msmediaview,default,default,Microsoft MediaView
odb,application/vnd.oasis.opendocument.database,default,database,OpenDocument Database
odc,application/vnd.oasis.opendocument.chart,default,log,OpenDocument Chart
odf,application/vnd.oasis.opendocument.formula,default,kformula,OpenDocument Formula
odg,application/vnd.oasis.opendocument.graphics,default,3d,OpenDocument Graphics
odp,application/vnd.oasis.opendocument.presentation,interactive,interactive,OpenDocument Presentation
ods,application/vnd.oasis.opendocument.spreadsheet,spreadsheet,spreadsheet,OpenDocument Spreadsheet
odt,application/vnd.oasis.opendocument.text,document,document,OpenDocument Text
oga,audio/ogg,audio,audio,Ogg Vorbis Audio Profile
ogg,audio/ogg,audio,audio,Ogg Vorbis Audio Codec Compressed Multimedia File
ogv,video/ogg,video,video,Ogg Video
onepkg,application/onenote,default,knotes,Microsoft OneNote
onetmp,application/onenote,default,knotes,Microsoft OneNote
onetoc,application/onenote,default,knotes,Microsoft OneNote
onetoc2,application/onenote,default,knotes,Microsoft OneNote
otf,font/otf,default,font,OpenType Font File
pdf,application/pdf,document,pdf,Adobe Portable Document Format
pic,image/pict,default,image,PICT Image
pict,image/pict,default,image,PICT Image
png,image/png,default,image,Portable Network Graphics (PNG)
pot,application/vnd.ms-powerpoint,interactive,interactive,Microsoft PowerPoint - Template
potm,application/vnd.ms-powerpoint.template.macroEnabled.12,interactive,interactive,Microsoft PowerPoint - Macro-Enabled Template File
potx,application/vnd.openxmlformats-officedocument.presentationml.template,interactive,interactive,Microsoft Office - OOXML - Presentation Template
ppam,application/vnd.ms-powerpoint.addin.macroEnabled.12,interactive,interactive,Microsoft PowerPoint - Add-in file
pps,application/vnd.ms-powerpoint,interactive,interactive,Microsoft PowerPoint - Slideshow
ppsm,application/vnd.ms-powerpoint.slideshow.macroEnabled.12,interactive,interactive,Microsoft PowerPoint - Macro-Enabled Slide Show File
ppsx,application/vnd.openxmlformats-officedocument.presentationml.slideshow,interactive,interactive,Microsoft Office - OOXML - Presentation (Slideshow)
ppt,application/vnd.ms-powerpoint,interactive,interactive,Microsoft PowerPoint - Presentation
pptm,application/vnd.ms-powerpoint.presentation.macroEnabled.12,interactive,interactive,Microsoft PowerPoint - Macro-Enabled Presentation File
pptx,application/vnd.openxmlformats-officedocument.presentationml.presentation,interactive,interactive,Microsoft Office - OOXML - Presentation
ps,application/postscript,default,postscript,Adobe PostScript
psd,image/vnd.adobe.photoshop,default,image,Adobe Photoshop Document
pub,application/x-mspublisher,document,document,Microsoft Publisher
qt,video/quicktime,video,quicktime,Quicktime Video
ra,audio/x-pn-realaudio,audio,audio,Real Audio
ram,audio/x-pn-realaudio,audio,audio,Real Audio Sound
rar,application/rar,archive,archive,RAR Archive
rgb,image/x-rgb,default,image,Silicon Graphics RGB Bitmap
rtf,application/rtf,document,document,Rich Text Format
rtx,text/richtext,text,text,Rich Text Format (RTF)
scd,application/x-msschedule,default,default,Microsoft Schedule+
sldm,application/vnd.ms-powerpoint.slide.macroEnabled.12,interactive,interactive,Microsoft PowerPoint - Macro-Enabled Open XML Slide
sldx,application/vnd.openxmlformats-officedocument.presentationml.slide,interactive,interactive,Microsoft Office - OOXML - Presentation (Slide)
snd,audio/basic,audio,audio,AU audio file - standard Internet/Java wave sound
sql,text/plain,default,database,Structured Query Language
sst,application/vnd.ms-pkicertstore,default,default,Microsoft Certificate Store
stl,application/vnd.ms-pkistl,default,default,Stereo Lithography File
svg,image/svg+xml,default,vectorgfx,Scalable Vector Graphics (SVG)
swf,application/x-shockwave-flash,interactive,interactive,Adobe Flash animation file
tar,application/x-tar,archive,archive,Tar File (Tape Archive)
tif,image/tiff,default,image,Taged Image File Format (bit map image)
tiff,image/tiff,default,image,Taged Image File Format (bit map image)
trm,application/x-msterminal,default,interactive,Microsoft Windows Terminal Services
tsv,text/tab-separated-values,text,text,Tab Seperated Values
ttf,font/ttf,default,font_truetype,TrueType Font
txt,text/plain,text,text,Text File
w6w,application/msword,document,document,Microsoft Word Document
wav,audio/x-wav,audio,audio,Microsoft Windows audio and video files
wax,audio/x-ms-wax,audio,audio,Microsoft Windows Media audio and video files
webm,video/webm,video,video,Open Web Media Project - Video
wm,video/x-ms-wm,video,video,Microsoft Windows Media (compressed video)
wma,audio/x-ms-wma,audio,audio,Microsoft Windows Media Audio (compressed audio)
wmf,application/x-msmetafile,default,vectorgfx,Microsoft Windows Metafile - proprietary format for vector graphics
wmv,video/x-ms-wmv,video,video,Microsoft Audio Format
wmx,video/x-ms-wmx,video,video,Microsoft Windows Media audio and video files
woff,font/x-woff,default,font,Web Open Font Format
word,application/msword,document,document,Microsoft Word Document
wp,application/wordperfect,document,document,WordPerfect 5
wpd,application/wordperfect,document,document,Wordperfect
wri,application/x-mswrite,document,document,Microsoft Wordpad
xla,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel Add-in
xlam,application/vnd.ms-excel.addin.macroEnabled.12,spreadsheet,spreadsheet,Microsoft Excel - Add-In File
xlc,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel Chart
xlm,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel Macro
xls,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel/Works Spreadsheet
xlsb,application/vnd.ms-excel.sheet.binary.macroEnabled.12,spreadsheet,spreadsheet,Microsoft Excel - Binary Workbook
xlsm,application/vnd.ms-excel.sheet.macroEnabled.12,spreadsheet,spreadsheet,Microsoft Excel - Macro-Enabled Workbook
xlsx,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,spreadsheet,spreadsheet,Microsoft Office - OOXML - Spreadsheet
xlt,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel Template
xltm,application/vnd.ms-excel.template.macroEnabled.12,spreadsheet,spreadsheet,Microsoft Excel - Macro-Enabled Template File
xltx,application/vnd.openxmlformats-officedocument.spreadsheetml.template,spreadsheet,spreadsheet,Microsoft Office - OOXML - Spreadsheet Template
xlw,application/vnd.ms-excel,spreadsheet,spreadsheet,Microsoft Excel Workspace
xml,application/xml,code,code,Atom Syndication Format
xsl,application/xml,code,style,XML Stylesheet
xslt,application/xslt+xml,code,code,XSL Transformations
zip,application/zip,archive,archive,WinZip/ PKZIP
<!-- template="mla-optional-mime-types" -->
123,application/vnd.lotus-1-2-3,Lotus 1-2-3
323,text/h323,H.323 messaging
3dm,x-world/x-3dmf,Apple QuickDraw 3D Metafile
3dmf,x-world/x-3dmf,Apple QuickDraw 3D Metafile
3dml,text/vnd.in3d.3dml,In3D - 3DML
3g2,video/3gpp2,3GPP files
3gp,video/3gp,ok for video or audio
3gp,video/3gpp,3GPP files
3gp2,video/3gpp2,3GPP files
3gpp,audio/3gp,audio only; also 3gp
3gpp,video/3gpp,3GPP files
7z,application/x-7z-compressed,7Zip compressed archive
a,application/octet-stream,
aab,application/x-authorware-bin,Adobe (Macropedia) Authorware - Binary File
aac,audio/aac,Apple QuickTime compressed audio used in iPods
aac,audio/MP4-LATM,Apple QuickTime compressed audio used in iPods
aac,audio/x-aac,Advanced Audio Coding (AAC)
aac,audio/x-mp4,Apple QuickTime compressed audio used in iPods
aam,application/x-authorware-map,Adobe (Macropedia) Authorware - Map
aas,application/x-authorware-map,Adobe (Macropedia) Authorware - Segment File
aas,application/x-authorware-seg,Adobe (Macropedia) Authorware - Segment File
abc,text/vnd.abc,
abw,application/x-abiword,AbiWord
ac,application/pkix-attr-cert,Attribute Certificate
ac3,audio/ac3,AC3 Audio File Format (Dolby Laboratories)
acc,application/vnd.americandynamics.acc,Active Content Compression
ace,application/x-ace-compressed,Ace Archive
acgi,text/html,
acu,application/vnd.acucobol,ACU Cobol
acx,application/internet-property-stream,
adp,audio/adpcm,Adaptive differential pulse-code modulation
adr,application/x-msaddr,
adt,audio/x-ms-adt,Audio Data Transport Stream (ADTS) audio files
adts,audio/x-ms-adt,Audio Data Transport Stream (ADTS) audio files
aep,application/vnd.audiograph,Audiograph
afl,video/animaflex,AnimaFlex RubberFlex Animation
afm,application/x-font-type1,Adobe font
afp,application/vnd.ibm.modcap,MO:DCA-P
ahead,application/vnd.ahead.space,Ahead AIR Application
ai,application/postscript,Adobe PostScript
aif,audio/aiff,Audio Interchange File Format/Macintosh sound
aif,audio/x-aiff,Audio Interchange File Format (AIFF) audio files
aifc,audio/aiff,Audio Interchange File Format/Macintosh sound
aifc,audio/x-aiff,Audio Interchange File Format (AIFF) audio files
aiff,audio/aiff,Audio Interchange File Format/Macintosh uncompressed sound
aiff,audio/x-aiff,Audio Interchange File Format (AIFF) audio files
aim,application/x-aim,
aip,text/x-audiosoft-intra,
air,application/vnd.adobe.air-application-installer-package+zip,Adobe AIR Application
ait,application/vnd.dvb.ait,Digital Video Broadcasting
alt,application/x-up-alert,
ami,application/vnd.amiga.ami,AmigaDE
ani,application/x-navi-animation,AOLPress/NaviPress animation
anx,application/annodex,
aos,application/x-nokia-9000-communicator-add-on-software,
apk,application/vnd.android.package-archive,Android Package Archive
application,application/x-ms-application,Microsoft ClickOnce
apr,application/vnd.lotus-approach,Lotus Approach
aps,application/mime,
arc,application/octet-stream,
arj,application/arj,
arj,application/octet-stream,
arj,application/x-arj,
art,image/x-jg,
asc,text/plain,text
asd,application/astound,
asf,video/x-ms-asf,Microsoft Windows Media advanced systems format
asm,text/x-asm,
asn,application/astound,
aso,application/vnd.accpac.simply.aso,Simply Accounting
asp,application/x-asap,
asp,text/asp,
asr,video/x-ms-asf,Microsoft Windows Media advanced systems format
asx,application/x-mplayer2,Microsoft video playlist. XML with entries giving URL for each file to play in order.
asx,video/x-ms-asf,Microsoft video playlist. XML with entries giving URL for each file to play in order.
asx,video/x-ms-asf-plugin,Microsoft video playlist. XML with entries giving URL for each file to play in order.
asz,application/astound,
atc,application/vnd.acucorp,ACU Cobol
atom,application/atom+xml,Atom Syndication Format
atomcat,application/atomcat+xml,Atom Publishing Protocol
atomsvc,application/atomsvc+xml,Atom Publishing Protocol Service Document
atx,application/vnd.antix.game-component,Antix Game Player
au,audio/basic,Sun Audio - standard Unix/Internet/Java uncompressed wave sound
au,audio/x-au,Sun Audio - standard Unix/Internet/Java uncompressed wave sound
au,audio/x-pn-au,Sun Audio - standard Unix/Internet/Java uncompressed wave sound
avi,application/x-troff-msvideo,Audio Video Interleave (AVI) - earlier Microsoft video format
avi,video/avi,Audio Video Interleave (AVI) - earlier Microsoft video format
avi,video/msvideo,Audio Video Interleave (AVI) - earlier Microsoft video format
avi,video/x-msvideo,Audio Video Interleave (AVI) - earlier Microsoft video format
avs,video/avs-video,Animation
aw,application/applixware,Applixware
axa,audio/annodex,Annodex Audio Profile
axs,application/olescript,
axv,video/annodex,Annodex Video Profile
azf,application/vnd.airzip.filesecure.azf,AirZip FileSECURE
azs,application/vnd.airzip.filesecure.azs,AirZip FileSECURE
azw,application/vnd.amazon.ebook,Amazon Kindle eBook format
bas,text/plain,Basic source
bat,application/octet-stream,DOS/Windows command line script
bat,text/plain,DOS/Windows command line script
batfrag,text/plain,fragment of a bat file.
bcpio,application/x-bcpio,Binary CPIO Archive
bdf,application/x-font-bdf,Glyph Bitmap Distribution Format
bdm,application/vnd.syncml.dm+wbxml,SyncML - Device Management
bed,application/vnd.realvnc.bed,RealVNC
bh2,application/vnd.fujitsu.oasysprs,Fujitsu Oasys
bild,image/jpeg,
bin,application/macbinary,Binary Data/executable program
bin,application/mac-binary,Binary Data/executable program
bin,application/octet-stream,Binary Data/executable program
bin,application/x-binary,Binary Data/executable program
bin,application/x-macbinary,Binary Data/executable program
bm,image/bmp,
bmi,application/vnd.bmi,BMI Drawing Data Interchange
bmp,image/bmp,Bitmap Image File
bmp,image/x-ms-bmp,Windows Bitmap Image File
bmp,image/x-windows-bmp,Windows Bitmap Image File
boo,application/book,
book,application/book,
box,application/vnd.previewsystems.box,Preview Systems ZipLock/VBox
boz,application/x-bzip2,
bsh,application/x-bsh,Bash (Unix Bourne Again SHell)
btif,image/prs.btif,BTIF
btmfrag,text/plain,fragment of a BTM file
bup,content/DVD,Backup to DVD
bz,application/x-bzip,Bzip Archive
bz2,application/x-bzip2,Bzip2 Archive
c,text/plain,C Source File
c,text/x-c,C Source File
c++,text/plain,C++ Source File
c11amc,application/vnd.cluetrust.cartomobile-config,ClueTrust CartoMobile - Config
c11amz,application/vnd.cluetrust.cartomobile-config-pkg,ClueTrust CartoMobile - Config Package
c4g,application/vnd.clonk.c4group,Clonk Game
cab,application/vnd.ms-cab-compressed,Microsoft Cabinet File
cacert,application/x-x509-ca-cert,
car,application/vnd.curl.car,CURL Applet
cat,application/vnd.ms-pki.seccat,Microsoft Trust UI Provider - Security Catalog
cat,application/vnd.ms-pkiseccat,Microsoft Trust UI Provider - Security Catalog
cc,text/plain,C++ Source File
cc,text/x-c,C++ Source File
ccad,application/clariscad,
cco,application/x-cocoa,
ccs,text/ccs,
ccxml,application/ccxml+xml,Voice Browser Call Control
cda,application/x-cdf,CD audio disc
cdbcmsg,application/vnd.contact.cmsg,CIM Database
cdf,application/cdf,Microsoft Channel Definition Format
cdf,application/x-cdf,Microsoft Channel Definition Format
cdf,application/x-netcdf,Microsoft Channel Definition Format
cdkey,application/vnd.mediastation.cdkey,MediaRemote
cdmia,application/cdmi-capability,Cloud Data Management Interface (CDMI) - Capability
cdmic,application/cdmi-container,Cloud Data Management Interface (CDMI) - Contaimer
cdmid,application/cdmi-domain,Cloud Data Management Interface (CDMI) - Domain
cdmio,application/cdmi-object,Cloud Data Management Interface (CDMI) - Object
cdmiq,application/cdmi-queue,Cloud Data Management Interface (CDMI) - Queue
cdr,application/x-cdr,
cdx,chemical/x-cdx,ChemDraw eXchange file
cdxml,application/vnd.chemdraw+xml,CambridgeSoft Chem Draw
cdy,application/vnd.cinderella,Interactive Geometry Software Cinderella
cer,application/pkix-cert,Internet Public Key Infrastructure - Certificate
cer,application/x-x509-ca-cert,X.509 Certificate format
cgm,image/cgm,Computer Graphics Metafile
cha,application/x-chat,pIRCh
chat,application/x-chat,pIRCh
che,application/x-up-cacheop,
chm,application/chm,Windows compiled help file format
chm,application/vnd.ms-htmlhelp,Microsoft Html Help File
chrt,application/vnd.kde.kchart,KDE KOffice Office Suite - KChart
cht,audio/x-dspeech,
cif,chemical/x-cif,Crystallographic Interchange Format
cii,application/vnd.anser-web-certificate-issue-initiation,ANSER-WEB Terminal Client - Certificate Issue
cil,application/vnd.ms-artgalry,Microsoft Artgalry
cla,application/vnd.claymore,Claymore Data Files
class,application/java,Compiled Java Bytecode File
class,application/java-byte-code,Compiled Java Bytecode File
class,application/java-class,Compiled Java Bytecode File
class,application/java-vm,Compiled Java Bytecode File
class,application/octet-stream,Compiled Java Bytecode File
class,application/x-java-applet,Compiled Java Bytecode File
class,application/x-java-class,Compiled Java Bytecode File
class,application/x-java-vm,Compiled Java Bytecode File
clkk,application/vnd.crick.clicker.keyboard,CrickSoftware - Clicker - Keyboard
clkp,application/vnd.crick.clicker.palette,CrickSoftware - Clicker - Palette
clkt,application/vnd.crick.clicker.template,CrickSoftware - Clicker - Template
clkw,application/vnd.crick.clicker.wordbank,CrickSoftware - Clicker - Wordbank
clkx,application/vnd.crick.clicker,CrickSoftware - Clicker
clp,application/x-msclip,Microsoft Clipboard Clip
clp,image/x-clp,IBM PCPaint image format
cmc,application/vnd.cosmocaller,CosmoCaller
cmd,text/plain,Windows NT command line script
cmdf,chemical/x-cmdf,CrystalMaker Data Format
cml,chemical/x-cml,Chemical Markup Language
cmp,application/vnd.yellowriver-custom-menu,CustomMenu
cmx,image/x-cmx,Corel Metafile Exchange (CMX)
cnc,application/x-cnc,
cod,application/vnd.rim.cod,Blackberry COD File
cod,image/cis-cod,
coda,application/x-coda,
com,application/octet-stream,executable program. You can use it for any file you want simply downloaded and as an intact binary. E.g. it would be useful for *.upd files in the Automatic File Update student project.
com,text/plain,
con,application/x-connector,
conf,text/plain,
cpi,image/cpi,
cpio,application/x-cpio,CPIO Archive
cpp,text/x-c,
cpt,application/mac-compactpro,Compact Pro
cpt,application/x-compactpro,Compact Pro
cpt,application/x-cpt,
crd,application/x-mscardfile,Microsoft Information Card
crl,application/pkix-crl,Internet Public Key Infrastructure - Certificate Revocation Lists
crt,application/pkix-cert,X.509 Certificate format
crt,application/x-x509-ca-cert,X.509 Certificate format
crt,application/x-x509-user-cert,X.509 Certificate format
cryptonote,application/vnd.rig.cryptonote,CryptoNote
csh,application/x-csh,C Shell Script
csh,text/x-script.csh,
csm,application/x-cu-seeme,
csml,chemical/x-csml,Chemical Style Markup Language
csp,application/vnd.commonspace,Sixth Floor Media - CommonSpace
css,application/x-pointplus,Cascading Style Sheets (CSS)
css,text/css,Cascading Style Sheets (CSS)
cssfrag,text/plain,
csv,text/comma-separated-values,Microsoft's format for import/export to Excel Word and Access.
csv,text/csv,Comma-Seperated Values
cu,application/cu-seeme,CU-SeeMe
cu,application/x-cu-seeme,CU-SeeMe
curl,text/vnd.curl,Curl - Applet
cut,image/x-halo-cut,
cww,application/prs.cww,CU-Writer
cxx,text/plain,
dae,model/vnd.collada+xml,COLLADA
daf,application/vnd.mobius.daf,Mobius Management Systems - UniversalArchive
dat,application/octet-stream,Various Data formats
dat,audio/dat,Digital Audio Tape
davmount,application/davmount+xml,Web Distributed Authoring and Versioning
dbf,application/octet-stream,
dcr,application/x-director,
dcurl,text/vnd.curl.dcurl,Curl - Detached Applet
dd2,application/vnd.oma.dd2+xml,OMA Download Agents
ddd,application/vnd.fujixerox.ddd,Fujitsu - Xerox 2D CAD Data
deb,application/x-debian-package,Debian Package
deepv,application/x-deepv,
def,text/plain,
der,application/x-x509-ca-cert,X.509 Certificate format
dfac,application/vnd.dreamfactory,DreamFactory
dif,video/x-dv,DVCPRO DV Video File
dif,application/excel,Microsoft Excel Data Interchange File
dif,application/vnd.ms-excel,Microsoft Excel Data Interchange File
dif,application/x-excel,Microsoft Excel Data Interchange File
dif,application/dif,Microsoft Excel Data Interchange File
dig,multipart/mixed,
dir,application/x-director,Adobe Shockwave Player
dis,application/vnd.mobius.dis,Mobius Management Systems - Distribution Database
djv,image/vnd.djvu,DjVu
djvu,image/vnd.djvu,DjVu
dl,video/dl,Animation
dl,video/x-dl,Animation
dll,application/octet-stream,Microsoft Windows Dynamic Link Library
dll,application/x-msdownload,Microsoft Windows Dynamic Link Library
dmg,application/octet-stream,OS-X distributable
dmg,application/x-apple-diskimage,OS-X distributable
dmp,application/octet-stream,Microsoft memory dump
dmp,application/x-dmp,Microsoft memory dump
dms,application/octet-stream,
dna,application/vnd.dna,New Moon Liftoff/DNA
doc,application/msword,Microsoft Word document formatted
docm,application/vnd.ms-word.document.macroenabled.12,Micosoft Word - Macro-Enabled Document
docx,application/vnd.openxmlformats-officedocument.wordprocessingml.document,Microsoft Office - OOXML - Word Document
dot,application/msword,Microsoft Word Document Template
dotm,application/vnd.ms-word.template.macroenabled.12,Micosoft Word - Macro-Enabled Template
dotx,application/vnd.openxmlformats-officedocument.wordprocessingml.template,Microsoft Office - OOXML - Word Document Template
dp,application/commonground,OSGi Deployment Package
dp,application/vnd.osgi.dp,OSGi Deployment Package
dpg,application/vnd.dpgraph,DPGraph
dra,audio/vnd.dra,DRA Audio
drw,application/drafting,
dsc,text/prs.lines.tag,PRS Lines Tag
dsf,image/x-mgx-dsf,
dss,text/dss,
dssc,application/dssc+der,Data Structure for the Security Suitability of Cryptographic Algorithms
dst,application/tajima,
dtb,application/x-dtbook+xml,Digital Talking Book
dtd,application/xml-dtd,Document Type Definition
dtd,text/xml,Document Type Definition
dts,audio/vnd.dts,DTS Audio
dtshd,audio/vnd.dts.hd,DTS High Definition Audio
dump,application/octet-stream,
dus,audio/x-dspeech,Readiris Font Dictionary
dv,video/x-dv,QuickTime Digital Video 
dvi,application/x-dvi,Device Independent File Format (DVI)
dvr-ms,video/x-ms-dvr,Microsoft Recorded TV Show
dwf,drawing/x-dwf,Autodesk Design Web Format (DWF)
dwf,model/vnd.dwf,Autodesk Design Web Format (DWF)
dwg,application/acad,DWG Drawing
dwg,image/vnd.dwg,DWG Drawing
dwg,image/x-dwg,DWG Drawing
dxf,application/dxf,AutoCAD DXF
dxf,image/vnd,AutoCAD DXF
dxf,image/vnd.dwg,AutoCAD DXF
dxf,image/vnd.dxf,AutoCAD DXF
dxf,image/x-dwg,AutoCAD DXF
dxp,application/vnd.spotfire.dxp,TIBCO Spotfire
dxr,application/x-director,
ear,application/java-archive,enterprise archive; EJB app; compiled compressed java plus data members.
ebk,application/x-expandedbook,
ecelp4800,audio/vnd.nuera.ecelp4800,Nuera ECELP 4800
ecelp7470,audio/vnd.nuera.ecelp7470,Nuera ECELP 7470
ecelp9600,audio/vnd.nuera.ecelp9600,Nuera ECELP 9600
ecert,application/x-x509-email-cert,
edm,application/vnd.novadigm.edm,Novadigm's RADIA and EDM products
edx,application/vnd.novadigm.edx,Novadigm's RADIA and EDM products
efif,application/vnd.picsel,Pcsel eFIF File
ei6,application/vnd.pg.osasli,Proprietary P&G Standard Reporting System
el,text/x-script.elisp,
elc,application/x-bytecode.elisp,Compiled elisp
elc,application/x-elc,
email,application/x-x509-email-cert,
emf,image/x-emf,
eml,message/rfc822,Email Message
emma,application/emma+xml,Extensible MultiModal Annotation
env,application/x-envoy,
eol,audio/vnd.digital-winds,Digital Winds Music
eot,application/vnd.ms-fontobject,Microsoft Embedded OpenType
eps,application/postscript,Encapsulated Adobe PostScript
epub,application/epub+zip,Electronic Publication
erf,application/x-hsp-erf,
es,application/ecmascript,ECMAScript
es,application/x-esrehber,
es,audio/echospeech,EchoCast Plugin
es3,application/vnd.eszigno3+xml,MICROSEC e-Szigno
esf,application/vnd.epson.esf,QUASS Stream Player
etf,image/x-etf,
etx,text/x-setext,Setext
evy,application/envoy,Envoy
evy,application/x-envoy,Envoy
exe,application/exe,Windows executable program. Refered to as an application type in the associations editor.
exe,application/octet-stream,Windows executable program. Refered to as an application type in the associations editor.
exe,application/x-msdos-download,Windows executable program. Refered to as an application type in the associations editor.
exe,application/x-msdownload,Windows executable program. Refered to as an application type in the associations editor.
exe,magnus-internal/cgi,Windows executable program. Refered to as an application type in the associations editor.
exi,application/exi,Efficient XML Interchange
exp,application/octet-stream,Visual C++ export files
ext,application/vnd.novadigm.ext,Novadigm's RADIA and EDM products
ez,application/andrew-inset,Andrew Toolkit
ez2,application/vnd.ezpix-album,EZPix Secure Photo Album
ez3,application/vnd.ezpix-package,EZPix Secure Photo Album
f,text/plain,
f,text/x-fortran,Fortran Source File
f4v,video/x-f4v,Flash Video
f77,text/x-fortran,
f90,text/plain,
f90,text/x-fortran,
fbs,image/vnd.fastbidsheet,FastBid Sheet
fcs,application/vnd.isac.fcs,International Society for Advancement of Cytometry
fdf,application/vnd.fdf,Abobe Acrobat form data
fdf,application/vnd.fdf,Forms Data Format
fe_launch,application/vnd.denovo.fcselayout-link,FCS Express Layout Link
fg5,application/vnd.fujitsu.oasysgp,Fujitsu Oasys
fh,image/x-freehand,FreeHand MX
fh4,image/x-freehand,
fh5,image/x-freehand,
fhc,image/x-freehand,
fif,application/fractals,
fif,image/fif,
fig,application/x-xfig,Xfig
flac,audio/flac,Free Lossless Audio Codec
fli,video/fli,FLI/FLC Animation Format
fli,video/x-fli,FLI/FLC Animation Format
flo,application/vnd.micrografx.flo,Micrografx
flo,image/florian,
flr,x-world/x-vrml,
flv,video/x-flv,Flash Video
flw,application/vnd.kde.kivio,KDE KOffice Office Suite - Kivio
flx,text/vnd.fmi.flexstor,FLEXSTOR
fly,text/vnd.fly,mod_fly / fly.cgi
fm,application/vnd.framemaker,FrameMaker Normal Format
fmf,video/x-atomic3d-feature,Atomic 3D Scene Creator and Editor
fml,application/fml,
fnc,application/vnd.frogans.fnc,Frogans Player
for,text/plain,
for,text/x-fortran,
fpx,image/vnd.fpx,FlashPix
fpx,image/vnd.net-fpx,
fpx,image/x-fpx,
frl,application/freeloader,
fs,application/X-FSRecipe,
fsc,application/vnd.fsc.weblaunch,Friendly Software Corporation
fst,image/vnd.fst,FAST Search & Transfer ASA
ftc,application/vnd.fluxtime.clip,FluxTime Clip
fti,application/vnd.anser-web-funds-transfer-initiation,ANSER-WEB Terminal Client - Web Funds Transfer
fvt,video/vnd.fvt,FAST Search & Transfer ASA
fxp,application/vnd.adobe.fxp,Adobe Flex Project
fzs,application/vnd.fuzzysheet,FuzzySheet
g,text/plain,
g2w,application/vnd.geoplan,GeoplanW
g3,image/g3fax,G3 Fax Image
g3w,application/vnd.geospace,GeospacW
gac,application/vnd.groove-account,Groove - Account
gdl,model/vnd.gdl,Geometric Description Language (GDL)
geo,application/vnd.dynageo,DynaGeo
gex,application/vnd.geometry-explorer,GeoMetry Explorer
ggb,application/vnd.geogebra.file,GeoGebra
ggt,application/vnd.geogebra.tool,GeoGebra
ghf,application/vnd.groove-help,Groove - Help
gif,image/gif,Graphics Interchange Format
gim,application/vnd.groove-identity-message,Groove - Identity Message
gl,video/gl,GALink Script
gl,video/gl,Graphical System for Presentation animation
gl,video/x-gl,Graphical System for Presentation animation
gmx,application/vnd.gmx,GameMaker ActiveX
gnumeric,application/x-gnumeric,Gnumeric
gph,application/vnd.flographit,NpGraphIt
gqf,application/vnd.grafeq,GrafEq
gram,application/srgs,Speech Recognition Grammar Specification
grv,application/vnd.groove-injector,Groove - Injector
grxml,application/srgs+xml,Speech Recognition Grammar Specification - XML
gsd,audio/gsm,GSM Internet Realtime Audio
gsd,audio/x-gsm,GSM Internet Realtime Audio
gsf,application/x-font-ghostscript,Ghostscript Font
gsm,audio/gsm,Raw Global System for Mobile Audio (GSM) 6.10 Audio Stream
gsm,audio/x-gsm,Raw Global System for Mobile Audio (GSM) 6.10 Audio Stream
gsp,application/x-gsp,
gss,application/x-gss,
gtar,application/x-gtar,GNU Tar Files
gtm,application/vnd.groove-tool-message,Groove - Tool Message
gtw,model/vnd.gtw,Gen-Trix Studio
gv,text/vnd.graphviz,Graphviz
gvi,application/x-gsp,Google Video; copy protected.
gvp,application/x-gsp,Google Video pointer
gxt,application/vnd.geonext,GEONExT and JSXGraph
gz,application/gzip,tar gzip
gz,application/x-compressed,tar gzip
gz,application/x-gzip,tar gzip
gzip,multipart/x-gzip,tar gzip
h,text/plain,C Header File
h,text/x-h,C Header File
h261,video/h261,H.261
h263,video/h263,H.263
h264,video/h264,H.264
hal,application/vnd.hal+xml,Hypertext Application Language
hbci,application/vnd.hbci,Homebanking Computer Interface (HBCI)
hdf,application/x-hdf,Hierarchical Data Format
hdml,text/x-hdml,
help,application/x-helpfile,
hgl,application/vnd.hp-hpgl,
hh,text/plain,
hh,text/x-h,
hlb,text/x-script,
hlp,application/hlp,Windows old-style help file format. See also chm. This is the MIME type Microsoft uses on its servers.
hlp,application/octet-stream,Windows old-style help file format. See also chm. This is the MIME type Microsoft uses on its servers.
hlp,application/winhlp,Windows old-style help file format. See also chm. This is the MIME type Microsoft uses on its servers.
hlp,application/x-helpfile,Windows old-style help file format. See also chm. This is the MIME type Microsoft uses on its servers.
hlp,application/x-winhelp,Windows old-style help file format. See also chm. This is the MIME type Microsoft uses on its servers.
hpg,application/vnd.hp-hpgl,
hpgl,application/vnd.hp-hpgl,HP-GL/2 and HP RTL
hpid,application/vnd.hp-hpid,Hewlett Packard Instant Delivery
hps,application/vnd.hp-hps,Hewlett-Packard's WebPrintSmart
hqx,application/binhex,Macintosh BinHex 4.0
hqx,application/binhex4,Macintosh BinHex 4.0
hqx,application/mac-binhex,Macintosh BinHex 4.0
hqx,application/mac-binhex40,Macintosh BinHex 4.0
hqx,application/x-binhex40,Macintosh BinHex 4.0
hqx,application/x-mac-binhex40,Macintosh BinHex 4.0
hta,application/hta,Microsoft HTML Application
htc,text/x-component,
htke,application/vnd.kenameaapp,Kenamea App
htm,text/html,HTML web browser
html,text/html,HyperText Markup Language (HTML)
htmlfrag,text/plain,fragment of an HTML file
htmls,text/html,
htt,text/webviewhtml,
htx,text/html,
hvd,application/vnd.yamaha.hv-dic,HV Voice Dictionary
hvp,application/vnd.yamaha.hv-voice,HV Voice Parameter
hvs,application/vnd.yamaha.hv-script,HV Script
i2g,application/vnd.intergeo,Interactive Geometry Software
ica,application/x-ica,Citrix
icc,application/vnd.iccprofile,ICC profile
ice,x-conference/x-cooltalk,CoolTalk
ico,image/x-icon,Icon Image
ics,text/calendar,iCalendar
idc,text/plain,
ief,image/ief,Image Exchange Format
iefs,image/ief,
ifb,text/calendar,Apple iCalendar
ifm,application/vnd.shana.informed.formdata,Shana Informed Filler
ifo,content/DVD,scene and timing info for a video
iges,application/iges,Initial Graphics Exchange Specification (IGES)
iges,model/iges,Initial Graphics Exchange Specification (IGES)
igl,application/vnd.igloader,igLoader
igm,application/vnd.insors.igm,IOCOM Visimeet
igs,application/iges,Initial Graphics Exchange Specification (IGES)
igs,model/iges,Initial Graphics Exchange Specification (IGES)
igx,application/vnd.micrografx.igx,Micrografx iGrafx Professional
iif,application/vnd.shana.informed.interchange,Shana Informed Filler
iii,application/x-iphone,
ima,application/x-ima,
imap,application/x-httpd-imap,
imp,application/vnd.accpac.simply.imp,Simply Accounting - Data Import
ims,application/vnd.ms-ims,Microsoft Class Server
inf,application/inf,
ins,application/x-internet-signup,
ins,application/x-NET-Install,
ip,application/x-ip2,
ipfix,application/ipfix,Internet Protocol Flow Information Export
ipk,application/vnd.shana.informed.package,Shana Informed Filler
ips,application/ips,
ips,application/x-ipscript,
ipx,application/x-ipix,
irm,application/vnd.ibm.rights-management,IBM DB2 Rights Manager
irp,application/vnd.irepository.package+xml,iRepository / Lucidoc Editor
isp,application/x-internet-signup,
isu,video/x-isvideo,
it,audio/it,Impulse Tracker
itp,application/vnd.shana.informed.formtemplate,Shana Informed Filler
iv,application/x-inventor,
ivp,application/vnd.immervision-ivp,ImmerVision PURE Players
ivr,i-world/i-vrml,
ivu,application/vnd.immervision-ivu,ImmerVision PURE Players
ivy,application/x-livescreen,
jad,text/vnd.sun.j2me.app-descriptor,J2ME cellphone or handheld application 
jam,application/vnd.jam,Lightspeed Audio Lab
jam,audio/x-jam,JamTracker (Music Module)
jar,application/java-archive,Java Archive
jar,application/x-jar,compiled compressed java plus data members.
jar.pack.gz,application/x-java-pack200,jars super-compressed with pack200.exe
jardiff,application/x-java-archive-diff,java jar update file; contains only jar members that have changed.
jav,text/plain,
jav,text/x-java-source,
java,text/plain,java source code
java,text/x-java-source,Java Source File
javafrag,text/plain,
jcm,application/x-java-commerce,
jfif,image/jpeg,
jfif,image/pipeg,
jfif,image/pjpeg,
jfif-tbnl,image/jpeg,
jisp,application/vnd.jisp,RhymBox
jlt,application/vnd.hp-jlyt,HP Indigo Digital Press - Job Layout Languate
jnlp,application/x-java-jnlp-file,Java Network Launching Protocol
jnlpfrag,text/plain,
joda,application/vnd.joost.joda-archive,Joda Archive
jp2,image/jp2,lossless JPEG-2000
jpe,image/jpeg,JPEG/JIFF Image
jpe,image/pjpeg,JPEG/JIFF Image
jpeg,image/jpeg,JPEG/JIFF Image
jpeg,image/pjpeg,JPEG/JIFF Image
jpg,image/jpeg,JPEG/JIFF Image
jpg,image/pjpeg,JPEG/JIFF Image
jpgv,video/jpeg,JPGVideo
jpm,video/jpm,JPEG 2000 Compound Image File Format
jps,image/x-jps,
js,application/ecmascript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
js,application/javascript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
js,application/x-javascript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
js,text/ecmascript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
js,text/javascript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
js,text/jscript,JavaScript; application/javascript is official; but text/javascript is more widely supported.
json,application/json,JavaScript Object Notation (JSON)
jut,image/jutvision,
kar,audio/midi,MIDI - Musical Instrument Digital Interface
kar,music/x-karaoke,
karbon,application/vnd.kde.karbon,KDE KOffice Office Suite - Karbon
kfo,application/vnd.kde.kformula,KDE KOffice Office Suite - Kformula
kia,application/vnd.kidspiration,Kidspiration
kml,application/vnd.google-earth.kml+xml,Google Earth - KML
kmz,application/vnd.google-earth.kmz,Google Earth - Zipped KML
kne,application/vnd.kinar,Kinar Applications
kon,application/vnd.kde.kontour,KDE KOffice Office Suite - Kontour
kpr,application/vnd.kde.kpresenter,KDE KOffice Office Suite - Kpresenter
ksh,application/x-ksh,
ksh,text/x-script.ksh,
ksp,application/vnd.kde.kspread,KDE KOffice Office Suite - Kspread
ktx,image/ktx,OpenGL Textures (KTX)
ktz,application/vnd.kahootz,Kahootz
kwd,application/vnd.kde.kword,KDE KOffice Office Suite - Kword
la,audio/nspaudio,Live Audio Plugin for NetScape
la,audio/x-nspaudio,Live Audio Plugin for NetScape
lam,audio/x-liveaudio,Live Audio Plugin for NetScape
lasxml,application/vnd.las.las+xml,Laser App Enterprise
latex,application/x-latex,LaTeX
lbd,application/vnd.llamagraphics.life-balance.desktop,Life Balance - Desktop Edition
lbe,application/vnd.llamagraphics.life-balance.exchange+xml,Life Balance - Exchange Format
les,application/vnd.hhe.lesson-player,Archipelago Lesson Player
lha,application/lha,
lha,application/octet-stream,
lha,application/x-lha,
lhx,application/octet-stream,
link66,application/vnd.route66.link66+xml,ROUTE 66 Location Based Services
list,text/plain,
lit,application/lit,
lma,audio/nspaudio,Live Audio Plugin for NetScape
lma,audio/x-nspaudio,Live Audio Plugin for NetScape
lnk,application/x-ms-shortcut,Windows shortcut file
log,text/plain,
lrm,application/vnd.ms-lrm,Microsoft Learning Resource Module
lsf,video/x-la-asf,Microsoft Advanced Systems Format (ASF)
lsp,application/x-lisp,Lots of Irritating Single Parentheses
lsp,text/lsp,Lots of Irritating Single Parentheses
lsp,text/x-script.lisp,Lots of Irritating Single Parentheses
lst,text/plain,program listing
lsx,text/x-la-asf,
lsx,video/x-la-asf,Microsoft Advanced Systems Format (ASF)
ltf,application/vnd.frogans.ltf,Frogans Player
ltx,application/x-latex,
lvp,audio/vnd.lucent.voice,Lucent Voice
lwp,application/vnd.lotus-wordpro,Lotus Wordpro
lwp,application/x-wordpro,
lzh,application/octet-stream,
lzh,application/x-lzh,
lzx,application/lzx,
lzx,application/octet-stream,
lzx,application/x-lzx,
m,text/plain,
m,text/x-m,
m13,application/x-msmediaview,Microsoft MediaView
m14,application/x-msmediaview,Microsoft MediaView
m1v,video/mpeg,MPEG video files
m1v,video/mpeg,MPEG video files
m21,application/mp21,MPEG-21
m2a,audio/mpeg,MPEG audio files
m2t,video/MP2T,AVCHD files
m2ts,video/MP2T,AVCHD files
m2v,video/mpeg,MPEG video files
m3u,audio/x-mpegurl,M3U (Multimedia Playlist)
m3u8,application/vnd.apple.mpegurl,Multimedia Playlist Unicode
m4a,audio/mp4,MPEG-4 Audio Layer
m4a,audio/mp4a-latm,MPEG-4 Audio Layer
m4a,audio/mpeg,MPEG audio files
m4b,audio/mp4a-latm,MPEG-4 Audio Layer Bookmarkable File
m4p,audio/mp4a-latm,MPEG-4 Audio Layer
m4u,audio/x-mpegurl,redirect to audio url
m4u,video/vnd.mpegurl,redirect to audio url
m4v,video/mp4,MPEG video files
m4v,video/x-m4v,M4v
ma,application/mathematica,Mathematica Notebooks
mac,image/x-macpaint,
mads,application/mads+xml,Metadata Authority Description Schema
mag,application/vnd.ecowin.chart,EcoWin Chart
man,application/x-troff-man,
map,application/x-navimap,AOLPress/NaviPress map
map,text/plain,link output
mar,text/plain,
mathml,application/mathml+xml,Mathematical Markup Language
mbd,application/mbedlet,
mbk,application/vnd.mobius.mbk,Mobius Management Systems - Basket file
mbox,application/mbox,Mbox database files
mc$,application/x-magic-cap-package-1.0,
mc1,application/vnd.medcalcdata,MedCalc
mcd,application/mcad,
mcd,application/vnd.mcd,Micro CADAM Helix D&D
mcd,application/x-mathcad,
mcf,image/vasa,
mcf,text/mcf,
mcp,application/netmc,
mcurl,text/vnd.curl.mcurl,Curl - Manifest File
mdb,application/mdb,Microsoft Access Database
mdb,application/x-msaccess,Microsoft Access Database
mdi,image/vnd.ms-modi,Microsoft Document Imaging Format
me,application/x-troff-me,
mesh,model/mesh,
meta4,application/metalink4+xml,Metalink
mets,application/mets+xml,Metadata Encoding and Transmission Standard
mfm,application/vnd.mfmp,Melody Format for Mobile Platform
mfp,application/mirage,
mgp,application/vnd.osgeo.mapguide.package,MapGuide DBXML
mgz,application/vnd.proteus.magazine,EFI Proteus
mht,message/rfc822,
mhtml,message/rfc822,
mid,application/x-midi,MIDI - Musical Instrument Digital Interface
mid,audio/mid,MIDI - Musical Instrument Digital Interface
mid,audio/midi,Musical Instrument Digital Interface (MIDI) audio files
mid,audio/x-mid,MIDI - Musical Instrument Digital Interface
mid,audio/x-midi,MIDI - Musical Instrument Digital Interface
mid,music/crescendo,MIDI - Musical Instrument Digital Interface
mid,x-music/x-midi,MIDI - Musical Instrument Digital Interface
midi,application/x-midi,MIDI - Musical Instrument Digital Interface
midi,audio/midi,Musical Instrument Digital Interface (MIDI) audio files
midi,audio/x-mid,MIDI - Musical Instrument Digital Interface
midi,audio/x-midi,MIDI - Musical Instrument Digital Interface
midi,music/crescendo,MIDI - Musical Instrument Digital Interface
midi,x-music/x-midi,MIDI - Musical Instrument Digital Interface
mif,application/vnd.mif,FrameMaker Interchange Format
mif,application/x-frame,FrameMaker Interchange Format
mif,application/x-mif,FrameMaker Interchange Format
mime,message/rfc822,
mime,www/mime,
mj2,video/mj2,Motion JPEG 2000
mjf,audio/x-vnd.audioexplosion.mjuicemediafile,Mjuice Secure Music Files
mjpg,video/x-motion-jpeg,MPEG video files
mlp,application/vnd.dolby.mlp,Dolby Meridian Lossless Packing
mm,application/base64,
mm,application/x-meme,
mmd,application/vnd.chipnuts.karaoke-mmd,Karaoke on Chipnuts Chipsets
mme,application/base64,
mmf,application/vnd.smaf,SMAF File
mml,text/mathml,Mathmatics Markup Language
mmr,image/vnd.fujixerox.edmics-mmr,EDMICS 2000
mny,application/x-msmoney,Microsoft Money
mod,audio/mod,MOD Plugin
mod,audio/x-mod,
mods,application/mods+xml,Metadata Object Description Schema
mol,chemical/x-mdl-molfile,
moov,video/quicktime,Quicktime movie player
mov,video/quicktime,Quicktime movie player
movie,video/x-sgi-movie,SGI Movie
mp2,audio/mpeg,MPEG audio files
mp2,audio/x-mpeg,MPEG audio files
mp2,video/mpeg,MPEG video files
mp2,video/x-mpeg,MPEG video files
mp2,video/x-mpeq2a,MPEG video files
mp2v,video/mpeg,MPEG video files
mp3,audio/mp3,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,audio/mpeg,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,audio/mpeg3,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,audio/x-mp3,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,audio/x-mpeg-3,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,audio/x-mpg,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,video/mpeg,mp3/mpeg compressed audio. Popular format for portable music players.
mp3,video/x-mpeg,mp3/mpeg compressed audio. Popular format for portable music players.
mp4,application/mp4,MPEG4
mp4,video/mp4,MPEG video files
mp4v,video/mp4,MPEG video files
mpa,audio/mpeg,MPEG audio files
mpa,audio/mpeg,MPEG audio files
mpc,application/vnd.mophun.certificate,Mophun Certificate
mpc,application/x-project,
mpe,video/mpeg,MPEG video files
mpeg,video/mpeg,MPEG video files
mpg,video/mpeg,MPEG video files
mpga,audio/mpeg,MPEG Audio
mpire,application/x-mpire,
mpkg,application/vnd.apple.installer+xml,Apple Installer Package
mpl,application/x-mpire,
mpm,application/vnd.blueice.multipass,Blueice Research Multipass
mpn,application/vnd.mophun.application,Mophun VM
mpp,application/vnd.ms-project,Microsoft Project
mpt,application/x-project,
mpv,application/x-project,
mpv2,video/mpeg,MPEG video files
mpx,application/x-project,
mpy,application/vnd.ibm.minipay,MiniPay
mqy,application/vnd.mobius.mqy,Mobius Management Systems - Query File
mrc,application/marc,MARC Formats
mrcx,application/marcxml+xml,MARC21 XML Schema
ms,application/x-troff-ms,
mscml,application/mediaservercontrol+xml,Media Server Control Markup Language
mseq,application/vnd.mseq,3GPP MSEQ File
msf,application/vnd.epson.msf,QUASS Stream Player
msg,application/vnd.ms-outlook,Microsoft Outlook Message
msh,model/mesh,Mesh Data Type
msi,application/msi,Microsoft install files
msi,application/x-msi,Microsoft install files
msl,application/vnd.mobius.msl,Mobius Management Systems - Script Language
msm,application/msm,
msty,application/vnd.muvee.style,Muvee Automatic Video Editing
mts,model/vnd.mts,Virtue MTS
mts,video/MP2T,AVCHD files
mus,application/vnd.musician,MUsical Score Interpreted Code Invented for the ASCII designation of Notation
musicxml,application/vnd.recordare.musicxml+xml,Recordare Applications
mv,video/x-sgi-movie,SGI Movie
mv4,video/mp4,MPEG video files
mvb,application/x-msmediaview,Microsoft MediaView
mwf,application/vnd.mfer,Medical Waveform Encoding Format
mxf,application/mxf,Material Exchange Format
mxl,application/vnd.recordare.musicxml,Recordare Applications
mxml,application/xv+xml,MXML
mxs,application/vnd.triscape.mxs,Triscape Map Explorer
mxu,video/vnd.mpegurl,MPEG Url
mzz,application/x-vnd.audioexplosion.mzz,
n2p,application/n2p,
n3,text/n3,Notation3
nap,image/naplps,
naplps,image/naplps,
nbp,application/vnd.wolfram.player,Mathematica Notebook Player
nc,application/x-netcdf,Network Common Data Form (NetCDF)
ncb,application/octet-stream,non-compiled browse
ncm,application/vnd.nokia.configuration-message,
ncx,application/x-dtbncx+xml,Navigation Control file for XML (for ePub)
n-gage,application/vnd.nokia.n-gage.symbian.install,N-Gage Game Installer
ngdat,application/vnd.nokia.n-gage.data,N-Gage Game Data
nif,image/x-niff,
niff,image/x-niff,
nix,application/x-mix-transfer,
nlu,application/vnd.neurolanguage.nlu,neuroLanguage
nml,application/vnd.enliven,Enliven Viewer
nnd,application/vnd.noblenet-directory,NobleNet Directory
nns,application/vnd.noblenet-sealer,NobleNet Sealer
nnw,application/vnd.noblenet-web,NobleNet Web
npx,application/x-netfpx,
npx,image/vnd.net-fpx,FlashPix
nsc,application/x-conference,
nsc,application/x-nschat,
nsf,application/vnd.lotus-notes,Lotus Notes
nvd,application/x-navidoc,AOLPress/NaviPress document
nws,message/rfc822,
o,application/octet-stream,
oa2,application/vnd.fujitsu.oasys2,Fujitsu Oasys
oa3,application/vnd.fujitsu.oasys3,Fujitsu Oasys
oas,application/vnd.fujitsu.oasys,Fujitsu Oasys
obd,application/x-msbinder,Microsoft Office Binder
obj,application/octet-stream,compiled object files
ocx,application/vnd.openxmlformats-officedocument.wordprocessingml.document,Object linking and embedding (OLE) Control eXtension
oda,application/oda,Office Document Architecture
odb,application/vnd.oasis.opendocument.database,OpenDocument Database
odc,application/vnd.oasis.opendocument.chart,OpenDocument Chart
odf,application/vnd.oasis.opendocument.formula,OpenDocument Formula
odft,application/vnd.oasis.opendocument.formula-template,OpenDocument Formula Template
odg,application/vnd.oasis.opendocument.graphics,OpenDocument Graphics
odi,application/vnd.oasis.opendocument.image,OpenDocument Image
odm,application/vnd.oasis.opendocument.text-master,OpenDocument Master Document
odp,application/vnd.oasis.opendocument.presentation,OpenDocument Presentation
ods,application/vnd.oasis.opendocument.spreadsheet,OpenDocument Spreadsheet
odt,application/vnd.oasis.opendocument.text,OpenDocument Text
ofml,application/fml,
oga,audio/ogg,Ogg Vorbis Audio Profile
ogg,application/ogg,Ogg Vorbis Audio Codec Compressed Multimedia File
ogg,audio/ogg,Ogg Vorbis Audio Codec Compressed Multimedia File
ogg,audio/x-oggvorbis,Ogg Vorbis Audio Codec Compressed Multimedia File
ogv,video/ogg,Ogg Video
ogx,application/ogg,muliplex ogg stream
omc,application/x-omc,
omcd,application/x-omcdatamaker,
omcr,application/x-omcregerator,
onetoc,application/onenote,Microsoft OneNote
opf,application/oebps-package+xml,Open eBook Publication Structure
org,application/vnd.lotus-organizer,Lotus Organizer
osf,application/vnd.yamaha.openscoreformat,Open Score Format
osfpvg,application/vnd.yamaha.openscoreformat.osfpvg+xml,OSFPVG
otc,application/vnd.oasis.opendocument.chart-template,OpenDocument Chart Template
otf,application/x-font-otf,OpenType Font File
otg,application/vnd.oasis.opendocument.graphics-template,OpenDocument Graphics Template
oth,application/vnd.oasis.opendocument.text-web,Open Document Text Web
oti,application/vnd.oasis.opendocument.image-template,OpenDocument Image Template
otp,application/vnd.oasis.opendocument.presentation-template,OpenDocument Presentation Template
ots,application/vnd.oasis.opendocument.spreadsheet-template,OpenDocument Spreadsheet Template
ott,application/vnd.oasis.opendocument.text-template,OpenDocument Text Template
oxt,application/vnd.openofficeorg.extension,OpenOffice.org extension
p,text/x-pascal,Pascal Source File
p10,application/pkcs10,PKCS #10 - Certification Request Standard
p10,application/x-pkcs10,
p12,application/pkcs-12,
p12,application/x-pkcs12,PKCS #12 - Personal Information Exchange Syntax Standard
p7a,application/x-pkcs7-signature,
p7b,application/x-pkcs7-certificates,PKCS #7 - Cryptographic Message Syntax Standard (Certificates)
p7c,application/pkcs7-mime,
p7c,application/x-pkcs7-mime,PKCS-7 binary public key export
p7m,application/pkcs7-mime,PKCS #7 - Cryptographic Message Syntax Standard
p7m,application/x-pkcs7-mime,encrypted file.
p7r,application/x-pkcs7-certreqresp,PKCS #7 - Cryptographic Message Syntax Standard (Certificate Request Response)
p7s,application/pkcs7-signature,PKCS #7 - Cryptographic Message Syntax Standard
p7s,application/x-pkcs7-signature,digtal signature.
p8,application/pkcs8,PKCS #8 - Private-Key Information Syntax Standard
pac,application/x-ns-proxy-autoconfig,
page,application/x-coda,
par,text/plain-bas,BAS Partitur Format
part,application/pro_eng,
pas,text/pascal,
paw,application/vnd.pawaafile,PawaaFILE
pbd,application/vnd.powerbuilder6,PowerBuilder
pbm,image/x-portable-bitmap,Portable Bitmap Format
pcf,application/x-font-pcf,Portable Compiled Format
pch,application/octet-stream,Visual Studio Precompiled Header
pcl,application/vnd.hp-pcl,HP Printer Command Language
pcl,application/x-pcl,
pclxl,application/vnd.hp-pclxl,PCL 6 Enhanced (Formely PCL XL)
pct,image/pict,
pct,image/x-pict,
pcurl,application/vnd.curl.pcurl,CURL Applet
pcx,image/x-pcx,PCX Image
pdb,application/vnd.palm,PalmOS Data
pdb,chemical/x-pdb,Protein Data Bank
pdf,application/pdf,Adobe Portable Document Format
pfa,application/x-font-type1,Adobe PostScript font
pfb,application/x-font-type1,Adobe PostScript font
pfm,application/x-font-type1,Adobe PostScript font
pfr,application/font-tdpfr,Portable Font Resource
pfx,application/x-pkcs12,PKCS-12 certificate
pgm,image/x-portable-graymap,Portable Graymap Format; grayscale image
pgn,application/x-chess-pgn,Portable Game Notation (Chess Games)
pgp,application/pgp-signature,Pretty Good Privacy - Signature
pgp,application/x-pgp-plugin,Pretty Good Privacy
pgr,text/parsnegar-document,
php,application/x-httpd-php,
php3,application/x-httpd-php3,
php4,application/x-httpd-php,
pic,image/pict,PICT Image
pic,image/x-pict,PICT Image
pict,image/pict,PICT Image
pkg,application/x-newton-compatible-pkg,
pki,application/pkixcmp,Internet Public Key Infrastructure - Certificate Management Protocole
pkipath,application/pkix-pkipath,Internet Public Key Infrastructure - Certification Path
pko,application/vnd.ms-pki.pko,
pl,text/plain,
pl,text/x-script.perl,
plb,application/vnd.3gpp.pic-bw-large,3rd Generation Partnership Project - Pic Large
plc,application/vnd.mobius.plc,Mobius Management Systems - Policy Definition Language File
plf,application/vnd.pocketlearn,PocketLearn Viewers
pls,application/pls,Pronunciation Lexicon Specification
pls,application/pls+xml,Pronunciation Lexicon Specification
plx,application/x-pixclscript,
pm,image/x-xpixmap,
pm,text/x-script.perl-module,
pm4,application/x-pagemaker,
pm5,application/x-pagemaker,
pma,application/x-perfmon,
pmc,application/x-perfmon,
pml,application/vnd.ctc-posml,PosML
pml,application/x-perfmon,
pmr,application/x-perfmon,
pmw,application/x-perfmon,
png,image/png,Portable Network Graphics (PNG)
pnm,application/x-portable-anymap,
pnm,image/x-portable-anymap,Portable Anymap Image
pnt,image/x-macpaint,
pntg,image/x-macpaint,
portpkg,application/vnd.macports.portpkg,MacPorts Port System
pot,application/mspowerpoint,Microsoft PowerPoint - Template
pot,application/vnd.ms-powerpoint,Microsoft PowerPoint - Template
potm,application/vnd.ms-powerpoint.template.macroenabled.12,Microsoft PowerPoint - Macro-Enabled Template File
potx,application/vnd.openxmlformats-officedocument.presentationml.template,Microsoft Office - OOXML - Presentation Template
pov,model/x-pov,
ppa,application/vnd.ms-powerpoint,
ppam,application/vnd.ms-powerpoint.addin.macroenabled.12,Microsoft PowerPoint - Add-in file
ppd,application/vnd.cups-ppd,Adobe PostScript Printer Description File Format
ppm,image/x-portable-pixmap,Portable Pixmap Format
pps,application/mspowerpoint,Microsoft PowerPoint - Slideshow
pps,application/vnd.ms-powerpoint,Microsoft PowerPoint - Slideshow
pps,application/x-mspowerpoint,Microsoft PowerPoint - Slideshow
ppsm,application/vnd.ms-powerpoint.slideshow.macroenabled.12,Microsoft PowerPoint - Macro-Enabled Slide Show File
ppsx,application/vnd.openxmlformats-officedocument.presentationml.slideshow,Microsoft Office - OOXML - Presentation (Slideshow)
ppsx,application/vnd.openxmlformats-officedocument.presentationml.slideshow,
ppt,application/mspowerpoint,Microsoft PowerPoint - Presentation
ppt,application/powerpoint,Microsoft PowerPoint - Presentation
ppt,application/vnd.ms-powerpoint,Microsoft PowerPoint - Presentation
ppt,application/x-mspowerpoint,Microsoft PowerPoint - Presentation
pptm,application/vnd.ms-powerpoint.presentation.macroenabled.12,Microsoft PowerPoint - Macro-Enabled Presentation File
pptx,application/vnd.openxmlformats-officedocument.presentationml.presentation,Microsoft Office - OOXML - Presentation
ppz,application/mspowerpoint,
pqf,application/x-cprplayer,
pqi,application/cprplayer,
prc,application/x-mobipocket,Mobipocket eBook
prc,application/x-mobipocket-ebook,Mobipocket
pre,application/vnd.lotus-freelance,Lotus Freelance
pre,application/x-freelance,
prf,application/pics-rules,PICSRules
prt,application/pro_eng,
prz,application/vnd.lotus-freelance,Lotus/IBM Freelance presenation
ps,application/postscript,Adobe PostScript
psb,application/vnd.3gpp.pic-bw-small,3rd Generation Partnership Project - Pic Small
psd,application/octet-stream,Adobe Photoshop Document
psd,image/photoshop,Adobe Photoshop Document
psd,image/psd,Adobe Photoshop Document
psd,image/vnd.adobe.photoshop,Adobe Photoshop Document
psd,image/x-photoshop,Adobe Photoshop Document
psf,application/x-font-linux-psf,PSF Fonts
pskcxml,application/pskc+xml,Portable Symmetric Key Container
psr,application/datawindow,
ptid,application/vnd.pvi.ptid1,Princeton Video Image
ptlk,application/listenup,
pub,application/x-mspublisher,Microsoft Publisher
push,multipart/x-mixed-replace,
pvb,application/vnd.3gpp.pic-bw-var,3rd Generation Partnership Project - Pic Var
pvu,paleovu/x-pv,
pwn,application/vnd.3m.post-it-notes,3M Post It Notes
pwz,application/vnd.ms-powerpoint,
py,text/x-script.phyton,
pya,audio/vnd.ms-playready.media.pya,Microsoft PlayReady Ecosystem
pyc,application/x-bytecode.python,
pyv,video/vnd.ms-playready.media.pyv,Microsoft PlayReady Ecosystem Video
qam,application/vnd.epson.quickanime,QuickAnime Player
qbo,application/vnd.intu.qbo,Open Financial Exchange
qcp,audio/vnd.qcelp,Qualcomm PureVoice 
qd3,x-world/x-3dmf,
qd3d,x-world/x-3dmf,
qfx,application/vnd.intu.qfx,Quicken
qif,image/x-quicktime,
qps,application/vnd.publishare-delta-tree,PubliShare Objects
qrt,application/quest,
qt,video/quicktime,Quicktime Video
qtc,video/quicktime,QuickTime Ver. 2.0 Windows CODEC
qtc,video/x-qtc,QuickTime Ver. 2.0 Windows CODEC
qti,image/x-quicktime,
qtif,image/x-quicktime,
qtl,application/x-quicktimeplayer,
qxd,application/vnd.quark.quarkxpress,QuarkXpress
ra,audio/x-pn-realaudio,Real Audio
ra,audio/x-pn-realaudio-plugin,Real Audio
ra,audio/x-realaudio,Real Audio
ram,audio/x-pn-realaudio,Real Audio Sound
rar,application/x-rar-compressed,RAR Archive
ras,application/x-cmu-raster,
ras,image/cmu-raster,
ras,image/x-cmu-raster,CMU Image
rast,image/cmu-raster,
rcprofile,application/vnd.ipunplugged.rcprofile,IP Unplugged Roaming Client
rdf,application/rdf+xml,Resource Description Framework
rdz,application/vnd.data-vision.rdz,RemoteDocs R-Viewer
rep,application/vnd.businessobjects,BusinessObjects
res,application/x-dtbresource+xml,Digital Talking Book - Resource File
rexx,text/x-script.rexx,
rf,image/vnd.rn-realflash,
rgb,image/x-rgb,Silicon Graphics RGB Bitmap
rif,application/reginfo+xml,IMS Networks
rip,audio/vnd.rip,Hit'n'Mix
rip,image/rip,
rl,application/resource-lists+xml,XML Resource Lists
rlc,image/vnd.fujixerox.edmics-rlc,EDMICS 2000
rld,application/resource-lists-diff+xml,XML Resource Lists Diff
rm,application/vnd.rn-realmedia,Real Media audio
rm,audio/x-pn-realaudio,Real Audio
rmf,audio/rmf,Beatnik Player Rich Music Format
rmf,audio/x-rmf,Beatnik Player Rich Music Format
rmi,audio/mid,MIDI - Musical Instrument Digital Interface
rmi,audio/midi,Musical Instrument Digital Interface (MIDI) audio files
rmm,audio/x-pn-realaudio,Real Audio
rmp,application/vnd.rn-rn_music_package,RealPlayer Metadata Package File; playlist
rmp,audio/x-pn-realaudio,RealPlayer Metadata Package File; playlist
rmp,audio/x-pn-realaudio-plugin,RealPlayer Metadata Package File; playlist
rms,application/vnd.jcp.javame.midlet-rms,Mobile Information Device Profile
rms,audio/x-realaudio-secure,Real Audio
rnc,application/relax-ng-compact-syntax,Relax NG Compact Syntax
rng,application/ringing-tones,Nokia phone ringtones. Also used for Relaxing.org schema files.
rng,application/vnd.nokia.ringing-tone,Nokia phone ringtones. Also used for Relaxing.org schema files.
rnx,application/vnd.rn-realplayer,
roff,application/x-troff,
rp,image/vnd.rn-realpix,
rp9,application/vnd.cloanto.rp9,RetroPlatform Player
rpm,audio/x-pn-realaudio-plugin,Real Audio
rpss,application/vnd.nokia.radio-presets,Nokia Radio Application - Preset
rpst,application/vnd.nokia.radio-preset,Nokia Radio Application - Preset
rq,application/sparql-query,SPARQL - Query
rrf,application/x-InstallFromTheWeb,
rs,application/rls-services+xml,XML Resource Lists
rsd,application/rsd+xml,Really Simple Discovery
rss,application/rss+xml,RSS - Really Simple Syndication
rss,text/xml,for RSS-2 podcasting feeds. Unfortunately it does not distinguish between text audio and video. RSS-1 uses application/xml or application/rdf+xml.
rt,text/richtext,
rt,text/vnd.rn-realtext,
rtc,application/rtc,
rtf,application/rtf,Rich Text Format
rtf,application/x-rtf,Rich Text Format
rtf,text/richtext,Rich Text Format
rtf,text/rtf,Rich Text Format
rtx,application/rtf,Rich Text Format (RTF)
rtx,text/richtext,Rich Text Format (RTF)
rv,video/vnd.rn-realvideo,RealVideo clip
s,text/x-asm,Assembler Source File
s3m,audio/s3m,ScreamTracker v3 Audio
saf,application/vnd.yamaha.smaf-audio,SMAF Audio
saveme,application/octet-stream,
sbk,application/x-tbook,
sbml,application/sbml+xml,Systems Biology Markup Language
sc,application/vnd.ibm.secure-container,IBM Electronic Media Management System - Secure Container
sca,application/x-supercard,
scd,application/x-msschedule,Microsoft Schedule+
scert,application/x-x509-server-cert,
scm,application/vnd.lotus-screencam,Lotus Screencam
scm,application/x-lotusscreencam,Lotus Screencam
scm,text/x-script.guile,Lotus Screencam
scm,text/x-script.scheme,Lotus Screencam
scm,video/x-scm,Lotus Screencam
scq,application/scvp-cv-request,Server-Based Certificate Validation Protocol - Validation Request
scr,application/octet-stream,Windows screensavers containing executable code. Beware! Frequently contain viruses.
scs,application/scvp-cv-response,Server-Based Certificate Validation Protocol - Validation Response
sct,text/scriptlet,
scurl,text/vnd.curl.scurl,Curl - Source Code
sda,application/vnd.stardivision.draw,StarOffice - Draw
sdc,application/vnd.stardivision.calc,StarOffice - Calc
sdd,application/vnd.stardivision.impress,StarOffice - Impress
sdkm,application/vnd.solent.sdkm+xml,SudokuMagic
sdml,text/plain,
sdp,application/sdp,Session Description Protocol
sdp,application/x-sdp,Session Description Protocol
sdr,application/sounder,
sdw,application/vnd.stardivision.writer,StarOffice - Writer
sea,application/sea,
sea,application/x-sea,
see,application/vnd.seemail,SeeMail
seed,application/vnd.fdsn.seed,Digital Siesmograph Networks - SEED Datafiles
sema,application/vnd.sema,Secured eMail
semd,application/vnd.semd,Secured eMail
semf,application/vnd.semf,Secured eMail
seq,application/octet-stream-bin,
ser,application/java-serialized-object,Java Serialized Object
ser,application/x-java-serialized-object,Java serialised object
set,application/set,
setpay,application/set-payment-initiation,Secure Electronic Transaction - Payment
setreg,application/set-registration-initiation,Secure Electronic Transaction - Registration
sfd-hdstx,application/vnd.hydrostatix.sof-data,Hydrostatix Master Suite
sfs,application/vnd.spotfire.sfs,TIBCO Spotfire
sgl,application/vnd.stardivision.writer-global,StarOffice - Writer (Global)
sgm,text/sgml,Standard Generalized Markup Language (SGML)
sgm,text/x-sgml,Standard Generalized Markup Language (SGML)
sgml,text/sgml,Standard Generalized Markup Language (SGML)
sgml,text/x-sgml,Standard Generalized Markup Language (SGML)
sh,application/x-bsh,Bourne Shell Script
sh,application/x-sh,Bourne Shell Script
sh,application/x-shar,Bourne Shell Script
sh,text/x-script.sh,Bourne Shell Script
shar,application/x-bsh,Shell Archive
shar,application/x-shar,Shell Archive
shf,application/shf+xml,S Hexdump Format
shtml,text/html,server side includes; web server expands embedded commands. Sometimes htm and html files are parsed for embedded commands too.
shtml,text/x-server-parsed-html,server side includes; web server expands embedded commands. Sometimes htm and html files are parsed for embedded commands too.
shw,application/presentations,
sid,audio/x-psid,Commodore64 (C64) Music File
sig,application/pgp-signature,
silo,model/mesh,
sis,application/vnd.symbian.install,Symbian Install Package
sit,application/x-sit,Stuffit Archive
sit,application/x-stuffit,Stuffit Archive
sitx,application/x-stuffitx,Stuffit Archive
sjf,application/octet-stream,
skd,application/x-koan,SSEYO Koan
skm,application/x-koan,SSEYO Koan
skp,application/vnd.koan,SSEYO Koan Play File
skp,application/x-koan,SSEYO Koan
skt,application/x-koan,SSEYO Koan
sl,application/x-seelogo,
sldm,application/vnd.ms-powerpoint.slide.macroenabled.12,Microsoft PowerPoint - Macro-Enabled Open XML Slide
sldx,application/vnd.openxmlformats-officedocument.presentationml.slide,Microsoft Office - OOXML - Presentation (Slide)
sln,text/plain,Microsoft Visual Solution file; options for debug/release builds
slt,application/vnd.epson.salt,SimpleAnimeLite Player
sm,application/vnd.stepmania.stepchart,StepMania
smf,application/vnd.stardivision.math,StarOffice - Math
smi,application/smil,Synchronized Multimedia Integration Language
smi,application/smil+xml,Synchronized Multimedia Integration Language
smil,application/smil,Synchronized Multimedia Integration Language
sml,application/smil,Synchronized Multimedia Integration Language
smp,application/studiom,
snd,audio/basic,AU audio file - standard Internet/Java wave sound
snd,audio/x-adpcm,AU audio file - standard Internet/Java wave sound
snf,application/x-font-snf,Server Normal Format
so,application/octet-stream,
sol,application/solids,
soundpack,application/octet-stream,Stardock Windows audio themes
spc,application/x-pkcs7-certificates,PKCS-7/X.509 Authenticode public key
spc,text/x-speech,PKCS-7/X.509 Authenticode public key
spf,application/vnd.yamaha.smaf-phrase,SMAF Phrase
spl,application/futuresplash,FutureSplash Animator
spl,application/x-futuresplash,FutureSplash Animator
spot,text/vnd.in3d.spot,In3D - 3DML
spp,application/scvp-vp-response,Server-Based Certificate Validation Protocol - Validation Policies - Response
spq,application/scvp-vp-request,Server-Based Certificate Validation Protocol - Validation Policies - Request
spr,application/x-sprite,
sprite,application/x-sprite,
spx,audio/ogg,Ogg (Speex Profile)
sql,text/plain,Structured Query Language
sqlfrag,text/plain,Structured Query Language (fragment)
src,application/x-wais-source,WAIS Source
sru,application/sru+xml,Search/Retrieve via URL Response Format
srx,application/sparql-results+xml,SPARQL - Results
sse,application/vnd.kodak-descriptor,Kodak Storyshare
ssf,application/vnd.epson.ssf,QUASS Stream Player
ssi,text/x-server-parsed-html,server side includes; web server expands embedded commands. Sometimes htm and html files are parsed for embedded commands too.
ssm,application/streamingmedia,
ssml,application/ssml+xml,Speech Synthesis Markup Language
sst,application/vnd.ms-pki.certstore,Microsoft Certificate Store
sst,application/vnd.ms-pkicertstore,Microsoft Certificate Store
st,application/vnd.sailingtracker.track,SailingTracker
stardock,application/octet-stream,
stc,application/vnd.sun.xml.calc.template,OpenOffice - Calc Template (Spreadsheet)
std,application/vnd.sun.xml.draw.template,OpenOffice - Draw Template (Graphics)
step,application/step,
stf,application/vnd.wt.stf,Worldtalk
sti,application/vnd.sun.xml.impress.template,OpenOffice - Impress Template (Presentation)
stk,application/hstu,
stk,application/hyperstudio,Hyperstudio
stl,application/sla,Stereo Lithography File 
stl,application/vnd.ms-pki.stl,Microsoft Trust UI Provider - Certificate Trust List
stl,application/vnd.ms-pkistl,Microsoft Trust UI Provider - Certificate Trust List
stl,application/x-navistyle,AOLPress/NaviPress stylesheet
stm,text/html,
stp,application/step,
str,application/vnd.pg.format,Proprietary P&G Standard Reporting System
stream,audio/x-qt-stream,QuickTime Stream
stw,application/vnd.sun.xml.writer.template,OpenOffice - Writer Template (Text - HTML)
sub,image/vnd.dvb.subtitle,Close Captioning - Subtitle
suo,application/octet-stream,Microsoft Visual Studio Solution User Options
sus,application/vnd.sus-calendar,ScheduleUs
sv4cpio,application/x-sv4cpio,System V Release 4 CPIO Archive
sv4crc,application/x-sv4crc,System V Release 4 CPIO Checksum Data
svc,application/vnd.dvb.service,Digital Video Broadcasting
svd,application/vnd.svd,SourceView Document
svf,image/vnd,
svf,image/vnd.dwg,
svf,image/x-dwg,
svg,image/svg+xml,Scalable Vector Graphics (SVG)
svh,image/svh,
svr,application/x-world,
svr,x-world/x-svr,
swa,application/x-director,
swf,application/x-shockwave-flash,Adobe Flash animation file
swi,application/vnd.aristanetworks.swi,Arista Networks Software Image
sxc,application/vnd.sun.xml.calc,OpenOffice - Calc (Spreadsheet)
sxd,application/vnd.sun.xml.draw,OpenOffice - Draw (Graphics)
sxg,application/vnd.sun.xml.writer.global,OpenOffice - Writer (Text - HTML)
sxi,application/vnd.sun.xml.impress,OpenOffice - Impress (Presentation)
sxm,application/vnd.sun.xml.math,OpenOffice - Math (Formula)
sxw,application/vnd.sun.xml.writer,OpenOffice - Writer (Text - HTML)
t,application/x-troff,typesetter 'roff
t,text/troff,typesetter 'roff
talk,application/talker,
talk,text/x-speech,
tao,application/vnd.tao.intent-module-archive,Tao Intent
tar,application/x-tar,Unix Tar File (Tape Archive)
tar,application/x-tar,Unix tar archive
tbk,application/toolbook,
tbk,application/x-tbook,
tcap,application/vnd.3gpp2.tcap,3rd Generation Partnership Project - Transaction Capabilities Application Part
tcl,application/x-tcl,Tcl Script
tcl,text/x-script.tcl,
tcsh,text/x-script.tcsh,
teacher,application/vnd.smart.teacher,SMART Technologies Apps
tei,application/tei+xml,Text Encoding and Interchange
tex,application/x-tex,TeX
texi,application/x-texinfo,GNU Texinfo Document
texinfo,application/x-texinfo,GNU Texinfo Document
text,application/plain,
text,text/plain,
tfi,application/thraud+xml,Sharing Transaction Fraud Data
tfm,application/x-tex-tfm,TeX Font Metric
tgz,application/gnutar,tar gzip
tgz,application/gzip,tar gzip
tgz,application/x-compressed,tar gzip
tgz,application/x-gzip,tar gzip
thmx,application/vnd.ms-officetheme,Microsoft Office System Release Theme
tif,image/tiff,Taged Image File Format (bit map image)
tif,image/x-tiff,Taged Image File Format (bit map image)
tiff,image/tiff,Taged Image File Format (bit map image)
tiff,image/x-tiff,Taged Image File Format (bit map image)
tld,text/xml,tag library description xml
tlk,application/x-tlk,
tmo,application/vnd.tmobile-livetv,MobileTV
tmv,application/x-Parable-Thing,
torrent,application/x-bittorrent,BitTorrent
tpl,application/vnd.groove-tool-template,Groove - Tool Template
tpt,application/vnd.trid.tpt,TRI Systems Config
tr,application/x-troff,typesetter 'roff
tra,application/vnd.trueapp,True BASIC
trm,application/x-msterminal,Microsoft Windows Terminal Services
troff,application/x-troff,
ts,audio/mpeg,MPEG-2 TS files
tsd,application/timestamped-data,Time Stamped Data Envelope
tsi,audio/tsp-audio,Microsoft Telephony Service Provider
tsi,audio/tsplayer,Microsoft Telephony Service Provider
tsp,application/dsptype,
tsp,audio/tsplayer,Microsoft Telephony Service Provider
tsq,application/timestamp-query,request to digitally sign and timestamp; usually a Jar digest. DER-base64 encoded.
tsr,application/timestamp-reply,response from a CA to digitally sign and timestamp; usually a Jar digest. DER-base64 encoded.
tsv,text/tab-separated-values,Tab Seperated Values
ttf,application/x-font-ttf,TrueType Font
ttf,font/ttf,TrueType font
ttl,text/turtle,Turtle (Terse RDF Triple Language)
tts,audio/mpeg,MPEG-2 TS files
turbot,image/florian,
twd,application/vnd.simtech-mindmapper,SimTech MindMapper
txd,application/vnd.genomatix.tuxedo,Genomatix Tuxedo Framework
txf,application/vnd.mobius.txf,Mobius Management Systems - Topic Index File
txt,text/plain,Text File
u98,urdu/urdu98,
ucert,application/x-x509-user-cert,
ufd,application/vnd.ufdl,Universal Forms Description Language
uil,text/x-uil,
uin,application/x-icq,
uls,text/iuls,
umj,application/vnd.umajin,UMAJIN
uni,text/uri-list,
unis,text/uri-list,
unityweb,application/vnd.unity,Unity 3d
unv,application/i-deas,
uoml,application/vnd.uoml+xml,Unique Object Markup Language
uri,text/uri-list,URI Resolution Services
uris,text/uri-list,URI Resolution Services
usercert,application/x-x509-user-cert,
usr,application/x-x509-user-cert,X.509 Certificate
ustar,application/x-ustar,Ustar (Uniform Standard Tape Archive)
ustar,multipart/x-ustar,
utz,application/vnd.uiq.theme,User Interface Quartz - Theme (Symbian)
uu,application/octet-stream,UUEncode
uu,text/x-uuencode,UUEncode
uue,text/x-uuencode,UUEncode
uva,audio/vnd.dece.audio,DECE Audio
uvh,video/vnd.dece.hd,DECE High Definition Video
uvi,image/vnd.dece.graphic,DECE Graphic
uvm,video/vnd.dece.mobile,DECE Mobile Video
uvp,video/vnd.dece.pd,DECE PD Video
uvs,video/vnd.dece.sd,DECE SD Video
uvu,video/vnd.uvvu.mp4,DECE MP4
uvv,video/vnd.dece.video,DECE Video
vb,text/vbscript,Visual Basic script
vbd,application/activexdocument,
vcd,application/x-cdlink,Video CD
vcf,text/x-vcard,vCard
vcg,application/vnd.groove-vcard,Groove - Vcard
vcs,text/x-vcalendar,vCalendar
vcx,application/vnd.vcx,VirtualCatalog
vda,application/vda,
vdo,video/vdo,VDOLive Script Video image (Story Board)
vew,application/groupwise,Novell GroupWise
vgm,video/x-videogram,Video Game Music
vgp,video/x-videogram-plugin,VG Player
vgx,video/x-videogram,VG Player Proprietry H.264 CODEC Video File
vis,application/vnd.visionary,Visionary
viv,video/vivo,Vivo
viv,video/vnd.vivo,Vivo
vivo,video/vivo,Vivo
vivo,video/vnd.vivo,Vivo
vmd,application/vocaltec-media-desc,
vmf,application/vocaltec-media-file,
vmi,application/x-dreamcast-vms-info,
vms,application/x-dreamcast-vms,
vob,video/dvd,Video OBject contains several streams multiplexed together: Video Audio and Subtitles. Video is MPEG-2
vob,video/mpeg,Video OBject contains several streams multiplexed together: Video Audio and Subtitles. Video is MPEG-3
voc,audio/voc,Creative Labs Sound Voice File
voc,audio/x-voc,Creative Labs Sound Voice File
vos,video/vosaic,Virtual Orchestra Studio Song Database
vox,audio/voxware,VoxWare MetaVoice Encoded Audio
vpa,application/vpa,
vqe,audio/x-twinvq-plugin,Transform-domain Weighted Interleave Vector Quantization (TwinVQF) Music File
vqf,audio/x-twinvq,Transform-domain Weighted Interleave Vector Quantization (TwinVQF) Music File
vql,audio/x-twinvq,Transform-domain Weighted Interleave Vector Quantization (TwinVQF) Music File
vql,audio/x-twinvq-plugin,Transform-domain Weighted Interleave Vector Quantization (TwinVQF) Music File
vrml,application/x-vrml,
vrml,model/vrml,
vrml,x-world/x-vrml,
vrt,x-world/x-vrt,
vsd,application/vnd.visio,Microsoft Visio
vsd,application/x-visio,Microsoft Visio
vsf,application/vnd.vsf,Viewport+
vst,application/x-visio,
vsw,application/x-visio,
vts,workbook/formulaone,VTK Visualization Toolkit Structured Grid
vtts,workbook/formulaone,VTK Visualization Toolkit Structured Grid
vtu,model/vnd.vtu,Virtue VTU
vxml,application/voicexml+xml,VoiceXML
w60,application/wordperfect6.0,Worderfect 6
w61,application/wordperfect6.1,WordPerfect
w6w,application/msword,Microsoft Word Document
wad,application/x-doom,Doom Video Game
waf,plugin/wanimate,
wan,plugin/wanimate,
war,application/java-archive,web archive; servlet app; compiled compressed java plus data members.
wav,audio/wav,Waveform Audio File Format (WAV); Microsoft wave uncompressed sound files
wav,audio/x-pn-windows-pcm,Waveform Audio File Format (WAV); Microsoft wave uncompressed sound files
wav,audio/x-wav,Waveform Audio File Format (WAV); Microsoft wave uncompressed sound files
wax,audio/x-ms-wax,Microsoft Windows Media Audio Redirector
wb1,application/x-qpro,
wbmp,image/vnd.wap.wbmp,WAP Bitamp (WBMP)
wbs,application/vnd.criticaltools.wbs+xml,Critical Tools - PERT Chart EXPERT
wbxml,application/vnd.wap.wbxml,WAP Binary XML (WBXML)
wcm,application/vnd.ms-works,
wdb,application/vnd.ms-works,
web,application/vnd.xara,
weba,audio/webm,Open Web Media Project - Audio
webm,video/webm,Open Web Media Project - Video
webp,image/webp,WebP Compact Image Format
wg,application/vnd.pmi.widget,Qualcomm's Plaza Mobile Internet
wgt,application/widget,Widget Packaging and XML Configuration
wi,image/wavelet,
wid,application/x-DemoShield,
wis,application/x-InstallShield,
wiz,application/msword,
wk1,application/x-123,
wks,application/vnd.ms-works,
wlt,application/x-mswallet,
wm,video/x-ms-wm,Microsoft Windows Media (compressed video)
wma,audio/x-ms-wma,Microsoft Windows Media Audio (compressed audio)
wmd,application/x-ms-wmd,Microsoft Windows Media Player Download Package
wmd,video/x-ms-wmd,Microsoft Windows Media audio and video files
wmf,application/x-msmetafile,Microsoft Windows Metafile - proprietary format for vector graphics
wmf,image/x-wmf,Microsoft Windows Metafile - proprietary format for vector graphics
wmf,windows/metafile,Microsoft Windows Metafile - proprietary format for vector graphics
wml,text/vnd.wap.wml,Wireless Markup Language (WML); VRML 3D virtual worlds; WAP
wml,x-world/x-vrml,Wireless Markup Language (WML); VRML 3D virtual worlds; WAP
wmlc,application/vnd.wap.wmlc,Compiled Wireless Markup Language (WMLC)
wmls,text/vnd.wap.wmlscript,Wireless Markup Language Script (WMLScript)
wmlsc,application/vnd.wap.wmlscriptc,WMLScript
wmp,video/x-ms-wmp,Microsoft Windows Media audio and video files
wmv,audio/x-ms-wmv,Microsoft Audio Format
wmv,video/x-ms-wmv,Microsoft Windows Media audio and video files
wmx,video/x-ms-wmx,Microsoft Windows Media Audio/Video Playlist
wmz,application/x-ms-wmz,Microsoft Windows Media Player Skin Package
woff,application/x-font-woff,Web Open Font Format
word,application/msword,Microsoft Word Document
wp,application/wordperfect,WordPerfect 5
wp5,application/wordperfect,WordPerfect 5
wp5,application/wordperfect6.0,
wp6,application/wordperfect,
wpd,application/vnd.wordperfect,Wordperfect
wpd,application/wordperfect5.1,Wordperfect
wpd,application/x-wpwin,Wordperfect
wpl,application/vnd.ms-wpl,Microsoft Windows Media audio and video files
wpl,application/vnd.ms-wpl,Microsoft Windows Media Player Playlist
wps,application/vnd.ms-works,Microsoft Works
wq1,application/x-lotus,
wqd,application/vnd.wqd,SundaHus WQ
wri,application/mswrite,Microsoft Wordpad
wri,application/write,Microsoft Wordpad
wri,application/x-mswrite,Microsoft Wordpad
wri,application/x-wri,Microsoft Wordpad
wrl,application/x-world,Virtual Reality Modeling Language
wrl,model/vrml,Virtual Reality Modeling Language
wrl,x-world/x-vrml,Virtual Reality Modeling Language
wrz,model/vrml,Virtual Reality Modeling Language
wrz,x-world/x-vrml,Virtual Reality Modeling Language
wsc,text/scriplet,
wsdl,application/wsdl+xml,WSDL - Web Services Description Language
wspolicy,application/wspolicy+xml,Web Services Policy
wsrc,application/x-wais-source,
wtb,application/vnd.webturbo,WebTurbo
wtk,application/x-wintalk,
wtv,video/x-ms-dvr,Microsoft Recorded TV Show
wtx,audio/wtx,WinTune Export Document
wvx,video/x-ms-wvx,Microsoft Windows Media Video Playlist
x3d,application/vnd.hzn-3d-crossword,3D Crossword Plugin
xaf,x-world/x-vrml,
xaml,application/xaml+xml,Silverlight
xap,application/x-silverlight-app,Microsoft Silverlight
xar,application/vnd.xara,CorelXARA
xbap,application/x-ms-xbap,Microsoft XAML Browser Application
xbd,application/vnd.fujixerox.docuworks.binder,Fujitsu - Xerox DocuWorks Binder
xbm,image/xbm,
xbm,image/x-xbm,
xdf,application/xcap-diff+xml,XML Configuration Access Protocol - XCAP Diff
xdm,application/vnd.syncml.dm+xml,SyncML - Device Management
xdp,application/vnd.adobe.xdp+xml,Adobe XML Data Package
xdr,text/xml,Microsoft BizTalk XML-Data Reduced Schema
xdr,video/x-amt-demorun,OpenSceneGraph 3D Graphics
xdssc,application/dssc+xml,Data Structure for the Security Suitability of Cryptographic Algorithms
xdw,application/vnd.fujixerox.docuworks,Fujitsu - Xerox DocuWorks
xenc,application/xenc+xml,XML Encryption Syntax and Processing
xer,application/patch-ops-error+xml,XML Patch Framework
xfdf,application/vnd.adobe.xfdf,Adobe XML Forms Data Format
xfdl,application/vnd.xfdl,Extensible Forms Description Language
xgz,xgl/drawing,
xht,application/xhtml+xml,XHTML - The Extensible HyperText Markup Language
xhtm,application/xhtml+xml,XHTML - The Extensible HyperText Markup Language
xhtml,application/xhtml+xml,XHTML - The Extensible HyperText Markup Language
xif,image/vnd.xiff,eXtended Image File Format (XIFF)
xl,application/excel,Microsoft Excel Spreadsheet
xla,application/excel,Microsoft Excel Add-in
xla,application/vnd.ms-excel,Microsoft Excel Add-in
xla,application/x-excel,Microsoft Excel Add-in
xla,application/x-msexcel,Microsoft Excel Add-in
xlam,application/vnd.ms-excel.addin.macroenabled.12,Microsoft Excel - Add-In File
xlb,application/excel,Microsoft Excel Spreadsheet
xlb,application/vnd.ms-excel,Microsoft Excel Spreadsheet
xlb,application/x-excel,Microsoft Excel Spreadsheet
xlc,application/excel,Microsoft Excel Chart
xlc,application/vnd.ms-excel,Microsoft Excel Chart
xlc,application/x-excel,Microsoft Excel Chart
xld,application/excel,Microsoft Excel Dialog
xld,application/x-excel,Microsoft Excel Dialog
xlk,application/excel,Microsoft Excel Backup
xlk,application/x-excel,Microsoft Excel Backup
xll,application/excel,Microsoft Excel Add-in
xll,application/vnd.ms-excel,Microsoft Excel Add-in
xll,application/x-excel,Microsoft Excel Add-in
xlm,application/excel,Microsoft Excel Macro
xlm,application/vnd.ms-excel,Microsoft Excel Macro
xlm,application/x-excel,Microsoft Excel Macro
xls,application/excel,Microsoft Excel/Works Spreadsheet
xls,application/vnd.ms-excel,Microsoft Excel/Works Spreadsheet
xls,application/x-excel,Microsoft Excel/Works Spreadsheet
xls,application/xls,Microsoft Excel/Works Spreadsheet
xls,application/x-msexcel,Microsoft Excel/Works Spreadsheet
xlsb,application/vnd.ms-excel.sheet.binary.macroenabled.12,Microsoft Excel - Binary Workbook
xlsm,application/vnd.ms-excel.sheet.macroenabled.12,Microsoft Excel - Macro-Enabled Workbook
xlsx,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,Microsoft Office - OOXML - Spreadsheet
xlt,application/excel,Microsoft Excel Template
xlt,application/vnd.ms-excel,Microsoft Excel Template
xlt,application/x-excel,Microsoft Excel Template
xlt,application/xlt,Microsoft Excel Template
xltm,application/vnd.ms-excel.template.macroenabled.12,Microsoft Excel - Macro-Enabled Template File
xltx,application/vnd.openxmlformats-officedocument.spreadsheetml.template,Microsoft Office - OOXML - Spreadsheet Teplate
xlv,application/excel,Microsoft Excel VBA
xlv,application/x-excel,Microsoft Excel VBA
xlw,application/excel,Microsoft Excel Workspace
xlw,application/vnd.ms-excel,Microsoft Excel Workspace
xlw,application/x-excel,Microsoft Excel Workspace
xlw,application/x-msexcel,Microsoft Excel Workspace
xm,audio/xm,Fast Tracker 2 Extended Module
xml,application/atom+xml,Atom Syndication Format
xml,application/rss+xml,RSS - Really Simple Syndication
xml,application/xml,XML - Extensible Markup Language; implies download
xml,text/xml,XML - Extensible Markup Language; implies display
xmlfrag,text/plain,fragment of an XML file
xmz,xgl/movie,
xo,application/vnd.olpc-sugar,Sugar Linux Application Bundle
xof,x-world/x-vrml,
xop,application/xop+xml,XML-Binary Optimized Packaging
xpi,application/x-xpinstall,XPInstall - Mozilla
xpix,application/x-vnd.ls-xpix,
xpm,image/xpm,X PixMap
xpm,image/x-xpixmap,X PixMap
x-png,image/png,
xpr,application/vnd.is-xpr,Express by Infoseek
xps,application/vnd.ms-xpsdocument,Microsoft XML Paper Specification
xpw,application/vnd.intercon.formnet,Intercon FormNet
xsd,application/xml,XML Schema; implies download
xsd,text/xml,XML Schema; implies display
xsl,application/xml,XML Stylesheet
xslt,application/xslt+xml,XSL Transformations
xsm,application/vnd.syncml+xml,SyncML
xspf,application/xspf+xml,XSPF - XML Shareable Playlist Format
xsr,video/x-amt-showrun,OpenSceneGraph 3D Graphics
xul,application/vnd.mozilla.xul+xml,XUL - XML User Interface Language
xwd,image/x-xwd,X Window Dump
xwd,image/x-xwindowdump,X Window Dump
xyz,chemical/x-pdb,
xyz,chemical/x-xyz,XYZ File Format
yang,application/yang,YANG Data Modeling Language
yin,application/yin+xml,YIN (YANG - XML)
z,application/x-compress,
z,application/x-compressed,
zaz,application/vnd.zzazz.deck+xml,Zzazz Deck
zip,application/x-compressed,WinZip/ PKZIP
zip,application/x-zip-compressed,WinZip/ PKZIP
zip,application/zip,WinZip/ PKZIP
zip,multipart/x-zip,WinZip/ PKZIP
zir,application/vnd.zul,Z.U.L. Geometry
zmm,application/vnd.handheld-entertainment+xml,ZVUE Media Manager
zoo,application/octet-stream,
zpa,application/pcphoto,
zsh,text/x-script.zsh,